EvaluateScript("images.js");
EvaluateScript("particles.js");
EvaluateScript("keys.js");
EvaluateScript("text.js");
EvaluateScript("levels.js");
EvaluateScript("dots.js");
EvaluateScript("audio.js");
EvaluateScript("ending.js");

function game()
{
		Intro();
		GameLoop(0);
}

var framerate = 1000/24;
var curr_level = 0;
var change_level = 0;

var last_mx;
var last_my;
function GameLoop(num)
{
	var exit = false;
	var last_time = GetTime();
	change_level = 0;
	curr_level = num;
	LoadLevel(num);
	lcount = 0;
	last_mx = GetMouseX();
	last_my = GetMouseY();
	
	var new_mx, new_my;
	
	while (exit == false)
	{
		if (GetMouseX() != last_mx||GetMouseY()!=last_my)
		{
			new_mx = Math.floor(2*(GetMouseX()-last_mx)/3)+last_mx;
			new_my = Math.floor(2*(GetMouseY()-last_my)/3)+last_my;
			if (GetMouseX() < 1||GetMouseX()> GetScreenWidth()-2);
				new_mx = GetMouseX();
			if (GetMouseY() < 1||GetMouseY()> GetScreenHeight()-2);
				new_my = GetMouseY();
			SetMousePosition(new_mx, new_my);
			last_mx = GetMouseX();
			last_my = GetMouseY();
		}

		lcount++;
		UpdateMusic();
		while(GetTime()-last_time<framerate);
		last_time = GetTime();
		DrawBackground();
		DrawForground();
		DrawHud();
		DrawForground2();
		DrawAll();

		FlipScreen();
		if (lcount > 50)
		{
			if (TimeCheck() == false)
			{
				UpdateParticles();
				UpdateTriggers();
			}
		}
		else
			DrawLevel();

		if (IsKeyPressed(KEY_ESCAPE) || change_level > 0)
			exit = true;
	}
	if (change_level == 1)
		GameLoop(num+1);
	else if (change_level == 2)
	{
		//show ending!
		Ending();
	}
}

function Intro()
{
	IntroLogo();
	StoryIntro();
	sounds[8].setVolume(64);
	sounds[8].setPitch(2);
	PlaySound(8, true);
	
	var counter1 = 0;
	var counter2 = 0;
	var canvas = CreateSurface(GetScreenWidth(), GetScreenHeight(), CreateColor(255,255,255,255));
	var pic1 = LoadSurface("pic1.png");
	var pic2 = LoadSurface("pic2.png");
	var pic3 = LoadSurface("pic3.png");
	var canvas2 = CreateSurface(pic1.width, pic1.height, CreateColor(255,255,255,255));
	var canvas3 = CreateSurface(pic1.width, pic1.height, CreateColor(255,255,255,255));
	var c1,c2;
	var counter3 = 0;
	var tsur = GrabSurface(0,0,GetScreenWidth(), GetScreenHeight());
	function DrawIntroBG()
	{
		canvas.zoomBlitMaskSurface(pic1, 0,0, 0.5, HueToColor((counter1/40)%6,25));

		for (l=0;l<12;l++)
		{
			c1 = HueToColor((counter1/20+l/2)%6,255);
			c2 = HueToColor((counter1/20+l/2+1/2)%6,255);
			canvas2.gradientRectangle(l*pic1.width/12,0, pic1.width/12, pic1.height, c1, c2, c2, c1)
		}

		canvas3.setBlendMode(REPLACE);
		canvas3.blitSurface(pic3,0,0);
		canvas3.setBlendMode(RGB_ONLY);
		canvas3.blitSurface(canvas2,0,0);


		canvas.setBlendMode(BLEND);
		canvas.zoomBlitSurface(canvas3,0,0,0.5);
		canvas.setBlendMode(MULTIPLY);
		canvas.zoomBlitSurface(pic2, 0,0,0.5);
		canvas.setBlendMode(BLEND);
		canvas.blit(0,0);
		if (counter1<40)
		{
			tsur.setAlpha(255-255*counter1/40);
			tsur.blit(0,0);
		}

		if (counter1>120)
		{
			counter3++;
			if (counter3 < 50)
			{
				font.setColorMask(CreateColor(255,255,255, (255*counter3)/50));
				font.drawText(180,4, "PRESS SPACE TO PLAY");
			}
			else
			{
				font.setColorMask(CreateColor(255,255,255, 255));
				font.drawText(180,4, "PRESS SPACE TO PLAY");
			}
		}
		//canvas3.blit(0,0);
	}

	
	var ltime = GetTime();
	while(IsKeyPressed(KEY_SPACE) == false)
	{
		counter1+=2;
		counter2+=2;
		DrawIntroBG();
		FlipScreen();
		
		while(GetTime()-ltime<1000/12);
		ltime=GetTime();
	
	}
	sounds[8].stop();
}

function IntroLogo()
{
	var canvas = CreateSurface(GetScreenWidth(), GetScreenHeight(), CreateColor(0,0,0,255));
	var canvas2 = CreateSurface(GetScreenWidth(), GetScreenHeight(), CreateColor(0,0,0,255));
	var canvas3 = CreateSurface(GetScreenWidth(), GetScreenHeight(), CreateColor(0,0,0,255));
	var county = 0;
	var lastt = GetTime();
	
	while(AreKeysLeft())
		GetKey();
	var string = "A Team Happy Rainbow Panda Bears Game";
	var x = GetScreenWidth()/2;
	var y = GetScreenHeight()-15;
	
	for (i=0;i<60 && !AreKeysLeft();i++)
	{
		FlipScreen();
		while(GetTime()-lastt < 1000/24);
		lastt = GetTime();
		canvas.blitMaskSurface(Images[0], 0,0, CreateColor(255,255,255,20));
		font.setColorMask(CreateColor(255,255,255,20));
		canvas.drawText(font, x-font.getStringWidth(string)/2, y-font.getHeight(), string);
		canvas.blit(0,0);
		if (i==50)
		{
			sounds[8].setVolume(64);
			PlaySound(8);
		}
	}
	
	function DrawIntroPreBG()
	{
		county++;
		canvas.blitMaskSurface(Images[0], 0,0, HueToColor((county/30)%6, 10));
		font.setColorMask(HueToColor((county/30)%6, 10));
		canvas.drawText(font, x-font.getStringWidth(string)/2, y-font.getHeight(), string);
		canvas.blit(0,0);
	}

	
	for (i=0;i<120 && !AreKeysLeft();i++)
	{
		FlipScreen();
		while(GetTime()-lastt < 1000/24);
		lastt = GetTime();
		DrawIntroPreBG();
	}
	font.setColorMask(CreateColor(255,255,255,255));
}
